<?php

/**
 * 输出首页内容
 */
function zibll_home_banner_display() {
    // 获取配置项
    $title1 = zibll_home_banner_get_option('banner_title1', '分享绿色');
    $title2 = zibll_home_banner_get_option('banner_title2', '与精品应用');
    $domain = zibll_home_banner_get_option('banner_domain', 'tfbkw.COM');
    $random_link = zibll_home_banner_get_option('random_link', 'https://www.902d.com/');
    $random_text = zibll_home_banner_get_option('random_text', '随便逛逛');
    $release_link = zibll_home_banner_get_option('release_link', 'https://www.902d.com/');
    $release_text = zibll_home_banner_get_option('release_text', '发布需求');
    
    // 获取分类按钮配置
    $categories = array(
        array(
            'name' => zibll_home_banner_get_option('cat1_name', '子比美化'),
            'link' => zibll_home_banner_get_option('cat1_link', 'https://www.902d.com/'),
            'icon' => zibll_home_banner_get_option('cat1_icon', 'icon-star-smile-fill'),
            'class' => 'wniui_one'
        ),
        array(
            'name' => zibll_home_banner_get_option('cat2_name', '建站资源'),
            'link' => zibll_home_banner_get_option('cat2_link', 'https://www.902d.com/'),
            'icon' => zibll_home_banner_get_option('cat2_icon', 'icon-fire-fill'),
            'class' => 'wniui_two'
        ),
        array(
            'name' => zibll_home_banner_get_option('cat3_name', '软件基地'),
            'link' => zibll_home_banner_get_option('cat3_link', 'https://www.902d.com/'),
            'icon' => zibll_home_banner_get_option('cat3_icon', 'icon-book-mark-fill'),
            'class' => 'wniui_three'
        )
    );
    
    // 获取轮播图配置（适配动态添加的轮播图组）
    $slides = array();
    $slides_data = zibll_home_banner_get_option('slides', array());
    
    // 处理轮播图数据：过滤启用状态 + 按排序序号排序
    if (!empty($slides_data) && is_array($slides_data)) {
        // 过滤启用的轮播图
        $enabled_slides = array_filter($slides_data, function($slide) {
            return isset($slide['enabled']) && $slide['enabled'] === '1' && !empty($slide['img']);
        });
        
        // 按排序序号排序（数字越小越靠前）
        usort($enabled_slides, function($a, $b) {
            $sort_a = isset($a['sort']) ? (int)$a['sort'] : 0;
            $sort_b = isset($b['sort']) ? (int)$b['sort'] : 0;
            return $sort_a - $sort_b;
        });
        
        // 整理轮播图数据
        foreach ($enabled_slides as $slide) {
            $slides[] = array(
                'link' => isset($slide['link']) ? $slide['link'] : '#',
                'img' => $slide['img'],
                'nofollow' => isset($slide['nofollow']) && $slide['nofollow'] === '1'
            );
        }
    }
    
    // 输出HTML
    ob_start();
    ?>
    <div id="home_top">
        <div class="recent-top-post-group" id="recent-top-post-group">
            <div class="recent-post-top" id="recent-post-top" style="display:flex;">
                <div id="bannerGroup">
                    <div id="banners">
                        <div class="banners-title">
                            <div class="banners-title-big"><?php echo esc_html($title1); ?></div>
                            <div class="banners-title-big"><?php echo esc_html($title2); ?></div>
                            <div class="banners-title-small"><?php echo esc_html($domain); ?></div>
                        </div>
                        
                        <!-- 完整标签图标组 -->
                        <div class="tags-group-all">
                            <div class="tags-group-wrapper">
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#989bf8"> <img title="AfterEffects" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/20239df3f66615b532ce571eac6d14ff21cf072602.png!cover"></div>
                                    <div class="tags-group-icon" style="background:#fff"> <img src="https://p.zhheo.com/2023e0ded7b724a39f12d59c3dc8fbdc7cbe074202.png!cover" title="Sketch" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#57b6e6"> <img title="Docker" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/20231108a540b2862d26f8850172e4ea58ed075102.png!cover"></div>
                                    <div class="tags-group-icon" style="background:#4082c3"> <img src="https://p.zhheo.com/2023e4058a91608ea41751c4f102b131f267075902.png!cover" title="Photoshop" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#fff"> <img src="https://p.zhheo.com/20233e777652412247dd57fd9b48cf997c01070702.png!cover" title="FinalCutPro" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" data-ll-status="loading"></div>
                                    <div class="tags-group-icon" style="background:#fff"> <img src="https://p.zhheo.com/20235c0731cd4c0c95fc136a8db961fdf963071502.png!cover" title="Python" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#eb6840"> <img title="Swift" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" src="https://p.zhheo.com/202328bbee0b314297917b327df4a704db5c072402.png!cover" data-ll-status="loading"></div>
                                    <div class="tags-group-icon" style="background:#8f55ba"> <img title="Principle" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/2023f76570d2770c8e84801f7e107cd911b5073202.png!cover"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#f29e39"> <img title="illustrator" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" src="https://p.zhheo.com/20237359d71b45ab77829cee5972e36f8c30073902.png!cover" data-ll-status="loading"></div>
                                    <div class="tags-group-icon" style="background:#2c51db"> <img src="https://p.zhheo.com/20237c548846044a20dad68a13c0f0e1502f074602.png!cover" title="CSS3" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" data-ll-status="loading"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#f7cb4f"> <img src="https://bu.dusays.com/2023/03/03/6401a79030db5.png" title="JS" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" data-ll-status="loading"></div>
                                    <div class="tags-group-icon" style="background:#e9572b"> <img src="https://p.zhheo.com/202372b4d760fd8a497d442140c295655426070302.png!cover" title="HTML" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" data-ll-status="loading"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#df5b40"> <img src="https://p.zhheo.com/2023ffa5707c4e25b6beb3e6a3d286ede4c6071102.png!cover" title="Git" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" data-ll-status="loading"></div>
                                    <div class="tags-group-icon" style="background:#1f1f1f"> <img src="https://bu.dusays.com/2023/03/03/6401a79030db5.png" title="Rhino" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" data-ll-status="loading"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#989bf8"> <img title="AfterEffects" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/20239df3f66615b532ce571eac6d14ff21cf072602.png!cover"></div>
                                    <div class="tags-group-icon" style="background:#fff"> <img title="Sketch" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/2023e0ded7b724a39f12d59c3dc8fbdc7cbe074202.png!cover"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#57b6e6"> <img title="Docker" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/20231108a540b2862d26f8850172e4ea58ed075102.png!cover"></div>
                                    <div class="tags-group-icon" style="background:#4082c3"> <img title="Photoshop" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/2023e4058a91608ea41751c4f102b131f267075902.png!cover"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#fff"> <img title="FinalCutPro" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/20233e777652412247dd57fd9b48cf997c01070702.png!cover"></div>
                                    <div class="tags-group-icon" style="background:#fff"> <img title="Python" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/20235c0731cd4c0c95fc136a8db961fdf963071502.png!cover"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#eb6840"> <img title="Swift" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/202328bbee0b314297917b327df4a704db5c072402.png!cover"></div>
                                    <div class="tags-group-icon" style="background:#8f55ba"> <img title="Principle" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/2023f76570d2770c8e84801f7e107cd911b5073202.png!cover"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#f29e39"> <img title="illustrator" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/20237359d71b45ab77829cee5972e36f8c30073902.png!cover"></div>
                                    <div class="tags-group-icon" style="background:#2c51db"> <img title="CSS3" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;" class="entered exited" src="https://p.zhheo.com/20237c548846044a20dad68a13c0f0e1502f074602.png!cover"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#f7cb4f"> <img src="https://p.zhheo.com/2023786e7fc488f453d5fb2be760c96185c0075502.png!cover" title="JS" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;"></div>
                                    <div class="tags-group-icon" style="background:#e9572b"> <img src="https://p.zhheo.com/202372b4d760fd8a497d442140c295655426070302.png!cover" title="HTML" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;"></div>
                                </div>
                                <div class="tags-group-icon-pair">
                                    <div class="tags-group-icon" style="background:#df5b40"> <img src="https://p.zhheo.com/2023ffa5707c4e25b6beb3e6a3d286ede4c6071102.png!cover" title="Git" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;"></div>
                                    <div class="tags-group-icon" style="background:#1f1f1f"> <img src="https://bu.dusays.com/2023/03/03/6401a79030db5.png" title="Rhino" onerror="this.onerror=null,this.src=&quot;https://bu.dusays.com/2023/03/03/6401a79030db5.png&quot;"></div>
                                </div>
                            </div>
                        </div>
                        
                        <a id="banner-hover" href="<?php echo esc_url($random_link); ?>" rel="external nofollow"> 
                            <i class="heofont icon-right"></i> 
                            <span class="bannerText"><?php echo esc_html($random_text); ?></span> 
                        </a>
                    </div>
                    
                    <!-- 分类按钮组 -->
                    <div class="categoryGroup">
                        <?php foreach ($categories as $cat) : ?>
                            <div class="categoryItem"> 
                                <a class="categoryButton <?php echo esc_attr($cat['class']); ?>" 
                                   href="<?php echo esc_url($cat['link']); ?>" 
                                   rel="external nofollow"> 
                                    <span class="categoryButtonText"><?php echo esc_html($cat['name']); ?></span> 
                                    <i class="heofont <?php echo esc_attr($cat['icon']); ?>"></i> 
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <!-- 轮播图区域 -->
                <div class="topGroup">
                    <div class="todayCard" id="todayCard" style="z-index: 1;" data-autoplay-delay="4000">
                        <div class="todayCard-info">
                            <div class="todayCard-tips"><?php echo esc_html($domain); ?></div>
                            <div class="todayCard-title"></div>
                        </div>
                        <div class="todayCard-cover-slides" style="position: relative; overflow: hidden;">
                            <div class="todayCard-slides-wrapper" style="transform: translateX(0%);">
                                <?php foreach ($slides as $slide) : ?>
                                    <a href="<?php echo esc_url($slide['link']); ?>" target="_blank" 
                                       class="todayCard-slide-item" 
                                       style="background-image: url('<?php echo esc_url($slide['img']); ?>');"
                                       <?php echo $slide['nofollow'] ? 'rel="external nofollow"' : ''; ?>>
                                        <span class="slide-link-area"></span>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                            <div class="todayCard-indicators">
                                <?php foreach ($slides as $index => $slide) : ?>
                                    <span class="indicator-dot <?php echo $index === 0 ? 'active' : ''; ?>" 
                                          data-idx="<?php echo $index; ?>"></span>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <div class="banner-button-group"> 
                            <a class="banner-button" href="<?php echo esc_url($release_link); ?>" rel="external nofollow"> 
                                <span class="banner-button-text"><?php echo esc_html($release_text); ?></span> 
                            </a>
                        </div> 
                        <span class="todayCard-arrow todayCard-arrow-left"> 
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="15 18 9 12 15 6"></polyline>
                            </svg> 
                        </span> 
                        <span class="todayCard-arrow todayCard-arrow-right"> 
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="9 18 15 12 9 6"></polyline>
                            </svg> 
                        </span>
                        <style>
        .todayCard-slides-wrapper a{z-index:999}
        .todayCard-slide-item .slide-link-area{pointer-events:none}
        .todayCard-slide-item .slide-link-area{display:block;width:100%;height:100%;pointer-events:none}
        .todayCard-cover-slides{position:relative;width:100%;height:100%;overflow:hidden;z-index:1}
        .todayCard-slides-wrapper{display:flex;transition:transform .8s cubic-bezier(.4,0,.2,1);will-change:transform}
        .todayCard-slide-item{flex:0 0 100%;background-size:cover;background-position:center;display:block;position:relative}
        .todayCard-slide-item .slide-link-area{display:block;width:100%;height:100%}
        .todayCard-indicators{position:absolute;left:0;right:0;bottom:10px;text-align:center;z-index:10;pointer-events:none}
        .todayCard-indicators .indicator-dot{display:inline-block;margin:0 3px;background:rgba(255,255,255,.7);transition:background .3s,border-radius .3s,width .3s,height .3s;cursor:pointer;pointer-events:auto;vertical-align:middle;width:7px;height:7px;border-radius:50%}
        .todayCard-indicators .indicator-dot.active{width:16px;height:6px;border-radius:3px;background:#fff}
    </style>
    
    <script>
        (function(){
            var card = document.getElementById('todayCard');
            if(!card) return;
            
            var wrapper = card.querySelector('.todayCard-slides-wrapper');
            var slides = wrapper ? wrapper.querySelectorAll('.todayCard-slide-item') : [];
            var indicatorsBox = card.querySelector('.todayCard-indicators');
            
            if(!slides.length) return;
            
            var idx = 0;
            var total = slides.length;
            
            if(indicatorsBox) {
                var html = '';
                for(var i = 0; i < total; i++) {
                    html += '<span class="indicator-dot" data-idx="' + i + '"></span>';
                }
                indicatorsBox.innerHTML = html;
            }
            
            var dots = indicatorsBox ? indicatorsBox.querySelectorAll('.indicator-dot') : [];
            
            function updateIndicators() {
                for(var i = 0; i < dots.length; i++) {
                    dots[i].classList.toggle('active', i === idx);
                }
            }
            
            function show(i) {
                idx = (i + total) % total;
                wrapper.style.transform = 'translateX(' + (-idx * 100) + '%)';
                updateIndicators();
            }
            
            show(0);
            
            function next() {
                show(idx + 1);
            }
            
            function prev() {
                show(idx - 1);
            }
            
            var left = card.querySelector('.todayCard-arrow-left');
            var right = card.querySelector('.todayCard-arrow-right');
            
            if(left) left.onclick = function() {
                prev();
                resetAutoPlay();
            };
            
            if(right) right.onclick = function() {
                next();
                resetAutoPlay();
            };
            
            if(dots.length) {
                for(var i = 0; i < dots.length; i++) {
                    (function(i) {
                        dots[i].onclick = function(e) {
                            e.stopPropagation();
                            show(i);
                            resetAutoPlay();
                        };
                    })(i);
                }
            }
            
            wrapper.addEventListener('wheel', function(e) {
                e.preventDefault();
                if(e.deltaY > 0) {
                    next();
                } else if(e.deltaY < 0) {
                    prev();
                }
                resetAutoPlay();
            }, {passive: false});
            
            var autoplayDelay = parseInt(card.getAttribute('data-autoplay-delay')) || 5000;
            var autoplayTimer = null;
            
            function startAutoPlay() {
                stopAutoPlay();
                autoplayTimer = setInterval(function() {
                    next();
                }, autoplayDelay);
            }
            
            function stopAutoPlay() {
                if(autoplayTimer) clearInterval(autoplayTimer);
                autoplayTimer = null;
            }
            
            function resetAutoPlay() {
                startAutoPlay();
            }
            
            card.addEventListener('mouseenter', stopAutoPlay);
            card.addEventListener('mouseleave', startAutoPlay);
            
            startAutoPlay();
        })();
    </script>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}