<?php

/**
 * 获取插件配置项的值
 */
function zibll_home_banner_get_option($key, $default = false) {
    static $options = null;
    if ($options === null) {
        $options_key = 'zibll_home_banner_options';
        $options = get_option($options_key);
    }
    return $options[$key] ?? $default;
}
function zibll_home_banner_admin_csf_options() {
    if (!is_admin()) {
        return;
    }

    $options_key = 'zibll_home_banner_options';

    CSF::createOptions($options_key, array(
        'menu_title'         => '卡片配置',
        'menu_slug'          => $options_key,
        'framework_title'    => 'zibll卡片插件配置',
        'show_in_customizer' => false,
        'footer_text'        => '插件配置面板- 902d.com',
        'footer_credit'      => '<i class="fa fa-fw fa-heart-o" aria-hidden="true"></i> ',
        'theme'              => 'light',
    ));

    // 基本设置
    CSF::createSection($options_key, array(
        'title'  => '基本设置',
        'icon'   => 'fa fa-home',
        'fields' => array(
            array(
                'id'      => 'banner_title1',
                'title'   => '横幅大标题1',
                'default' => '分享绿色',
                'type'    => 'text',
                'desc'    => '横幅区域显示的第一个大标题'
            ),
            array(
                'id'      => 'banner_title2',
                'title'   => '横幅大标题2',
                'default' => '与精品应用',
                'type'    => 'text',
                'desc'    => '横幅区域显示的第二个大标题'
            ),
            array(
                'id'      => 'banner_domain',
                'title'   => '域名显示',
                'default' => 'tfbkw.COM',
                'type'    => 'text',
                'desc'    => '显示在标题下方的域名/网站标识'
            ),
            array(
                'id'      => 'random_link',
                'title'   => '随便逛逛链接',
                'default' => 'https://www.902d.com/',
                'type'    => 'text',
                'desc'    => '设置"随便逛逛"按钮的链接'
            ),
            array(
                'id'      => 'random_text',
                'title'   => '随便逛逛文本',
                'default' => '随便逛逛',
                'type'    => 'text',
                'desc'    => '设置"随便逛逛"按钮的显示文本'
            ),
            array(
                'id'      => 'release_link',
                'title'   => '发布需求链接',
                'default' => 'https://www.902d.com/',
                'type'    => 'text',
                'desc'    => '设置"发布需求"按钮的链接'
            ),
            array(
                'id'      => 'release_text',
                'title'   => '发布需求文本',
                'default' => '发布需求',
                'type'    => 'text',
                'desc'    => '设置"发布需求"按钮的显示文本'
            ),
        )
    ));

   // 分类按钮设置
CSF::createSection($options_key, array(
    'title'  => '分类按钮设置',
    'icon'   => 'fa fa-th-list',
    'fields' => array(
        array(
            'id'      => 'cat1_name',
            'title'   => '分类1名称',
            'default' => '子比美化',
            'type'    => 'text'
        ),
        array(
            'id'      => 'cat1_link',
            'title'   => '分类1链接',
            'default' => 'https://www.902d.com/',
            'type'    => 'text'
        ),
        array(
            'id'      => 'cat2_name',
            'title'   => '分类2名称',
            'default' => '建站资源',
            'type'    => 'text'
        ),
        array(
            'id'      => 'cat2_link',
            'title'   => '分类2链接',
            'default' => 'https://www.902d.com/',
            'type'    => 'text'
        ),
        array(
            'id'      => 'cat3_name',
            'title'   => '分类3名称',
            'default' => '软件基地',
            'type'    => 'text'
        ),
        array(
            'id'      => 'cat3_link',
            'title'   => '分类3链接',
            'default' => 'https://www.902d.com/',
            'type'    => 'text'
        ),
    )
));

    CSF::createSection($options_key, array(
        'title'  => '轮播图设置',
        'icon'   => 'fa fa-image',
        'fields' => array(
            array(
                'id'          => 'slides',
                'type'        => 'group',
                'title'       => '轮播图列表',
                'button_title' => '添加轮播图',
                'accordion'   => true,
                'fields'      => array(
                    array(
                        'id'      => 'enabled',
                        'title'   => '启用此轮播图',
                        'default' => '1',
                        'type'    => 'switcher',
                        'desc'    => '关闭后该轮播图将不显示在前端'
                    ),
                    array(
                        'id'      => 'img',
                        'title'   => '轮播图图片',
                        'type'    => 'upload',
                        'desc'    => '上传轮播图图片，建议尺寸统一',
                        'library' => 'image',
                        'mime_types' => 'jpg,jpeg,png,webp'
                    ),
                    array(
                        'id'      => 'link',
                        'title'   => '轮播图链接',
                        'default' => '#',
                        'type'    => 'text',
                        'desc'    => '点击轮播图后跳转的目标链接'
                    ),
                    array(
                        'id'      => 'nofollow',
                        'title'   => '启用 nofollow 属性',
                        'default' => '1',
                        'type'    => 'switcher',
                        'desc'    => '为链接添加 rel="external nofollow" 属性，建议外部链接启用'
                    ),
                    array(
                        'id'      => 'sort',
                        'title'   => '排序序号',
                        'default' => 0,
                        'type'    => 'number',
                        'desc'    => '数字越小排序越靠前，默认为0'
                    )
                )
            )
        )
    ));
}
add_action('zib_require_end', 'zibll_home_banner_admin_csf_options');