<?php

/**
 * 创建首页横幅小工具www.902d.com
 */
function zibll_home_banner_create_widget() {
    $widget_key = 'zibll_home_banner_widget';

    Zib_CFSwidget::create($widget_key, array(
        'title'       => '滚动推荐卡片',
        'zib_title'   => false,
        'zib_affix'   => false,
        'zib_show'    => true,
        'description' => '显示自定义首页横幅区域，包含标签、分类和轮播图',
        'fields'      => array(
            array(
                'id'      => 'show_tags',
                'title'   => '显示标签图标',
                'default' => '1',
                'type'    => 'switcher',
                'desc'    => '是否显示标签图标组'
            ),
        )
    ));
}
add_action('zib_require_end', 'zibll_home_banner_create_widget');

/**
 * 小工具内容输出函数
 */
function zibll_home_banner_widget($args, $instance) {
    // 显示控制
    $show_class = Zib_CFSwidget::show_class($instance);
    if (!$show_class) {
        return;
    }

    // 获取配置
    $show_tags = $instance['show_tags'] ?? '1';

    Zib_CFSwidget::echo_before($instance);

    // 输出内容
    echo '<style>';
    if ($show_tags != '1') {
        echo '.tags-group-all { display: none; }';
    }
    echo '</style>';
    
    echo zibll_home_banner_display();

    Zib_CFSwidget::echo_after($instance);
}