<?php
/**
 * Plugin Name:  zibll – 滚动推荐卡片小工具
 * Description:  子比主题 – 滚动推荐卡片小工具，使用说明：设置菜单栏配置完成后在小工具页面找到“Zibll 滚动推荐卡片”添加显示位置
 * Version:      1.0.0
 * Plugin URI:   https://www.902d.com/
 * Author:       星辰玩转
 * Author URI:   https://www.902d.com/
 * Requires PHP: 7.0-8.5
 */

// 防止直接访问
if (!defined('ABSPATH')) {
    exit;
}

/**
 * 判断依赖主题是否启用
 */
function zibll_home_banner_error_notices() {
    $con = '<div class="notice notice-error is-dismissible">
                <h3>插件错误！</h3>
                <p>此插件依赖于zibll主题，请先启用zibll子比主题</p></div>';
    echo $con;
}

if (get_stylesheet() != 'zibll') {
    add_action('admin_notices', 'zibll_home_banner_error_notices');
    return;
}

// 引入必要的文件
require_once dirname(__FILE__) . '/inc/functions.php';
require_once dirname(__FILE__) . '/inc/options.php';
require_once dirname(__FILE__) . '/inc/widget.php';

/**
 * 插件激活时执行的函数
 */
function zibll_home_banner_activation_hook() {
    // 初始化默认设置
    $default_options = array(
        'banner_title1' => '分享绿色',
        'banner_title2' => '与精品应用',
        'banner_domain' => '902d.com',
        'random_link' => 'https://www.902d.com/',
        'random_text' => '随便逛逛',
        'release_link' => 'https://www.902d.com/',
        'release_text' => '发布需求',
    );
    update_option('zibll_home_banner_options', $default_options);
}
register_activation_hook(__FILE__, 'zibll_home_banner_activation_hook');

/**
 * 前台引入资源文件
 */
function zibll_home_banner_enqueue_scripts() {
    $ver = '1.0.0';
    
    wp_enqueue_style('zibll-home-banner', plugin_dir_url(__FILE__) . 'assets/css/qwq.css', array(), $ver);
}
add_action('wp_enqueue_scripts', 'zibll_home_banner_enqueue_scripts');